﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace VeteransAffairs.Registries.BusinessAHOBPR
{
    public partial class REGISTRANT_SERVICE_EPISODE : IComparable<REGISTRANT_SERVICE_EPISODE>
    {
        private DateTime ComparableEndDate
        {
            get
            {
                if (this.SERVICE_EPISODE_END_DATE.HasValue)
                {
                    return this.SERVICE_EPISODE_END_DATE.Value;
                }
                return DateTime.Now;
            }
        }

        private DateTime ComparableStartDate
        {
            get
            {
                if (this._SERVICE_EPISODE_START_DATE.HasValue)
                {
                    return this._SERVICE_EPISODE_START_DATE.Value;
                }
                return new DateTime(1900, 1, 1);
            }
        }

        public int CompareTo(REGISTRANT_SERVICE_EPISODE other)
        {
            int endDateComparison = this.ComparableEndDate.CompareTo(other.ComparableEndDate);
            if (endDateComparison == 0)
            {
                int startDateComparison = this.ComparableStartDate.CompareTo(other.ComparableStartDate);
                if (startDateComparison == 0)
                {
                    return -1 * this.CREATED.CompareTo(other.CREATED);
                }
                return startDateComparison * -1;
            }
            return endDateComparison * -1;
        }
    }
}
